/* A player with a name playing the game at a level.
     level 1 means look only at hours
     level 2 means look at hours and minutes divisible by 15
     level 3 means look at hours and minutes divisible by 5
     level 4 means look at hours and minutes
   The score is initially 0. Whenever it is incremented to
   a value that is divisible by 5, the level is incremented
   (but the level never gets bigger than 4)
   */

public class Player {
   private String name= "";  // The player's name
   private int level= 1;     // The game level, in range 1..4
   private int score= 0;     // Current score, >= 0
   
   /** Constructor: a player named s, starting at level lev */
   public Player(String s, int lev) {
      name= s;
      level= lev;
      score= 0;
   }
   
   /** = level at which game is being played */
   public int getLevel() {
      return level;
   }
   
   /** = player's name */
   public String getName() {
      return name;
   }
   
   /** = player's score */
   public int getScore() {
      return score;
   }
   
   /** increment score --and increase level as
       per specification at head of class */
   public void incrementScore() {
      score= score+1;
      if (score % 5 == 0 && level != 4)
         level= level+1;
   }
   
   /** = string representation of player */
   public String toString() {
      return name + ", level " + level + ", score " + score;
   }
}
